<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWaypointsTable extends Migration {

	public function up()
	{
		Schema::create('waypoints', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->float('location_lat');
			$table->float('location_long');
			$table->string('name');
			$table->integer('code')->index();
		});
	}

	public function down()
	{
		Schema::drop('waypoints');
	}
}