<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('mentors', function(Blueprint $table) {
			$table->foreign('tag_id')->references('id')->on('tags')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('mentors', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('social_links', function(Blueprint $table) {
			$table->foreign('mentor_id')->references('id')->on('mentors')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('packages', function(Blueprint $table) {
			$table->foreign('mentor_id')->references('id')->on('mentors')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('packages', function(Blueprint $table) {
			$table->foreign('package_section_id')->references('id')->on('package_sections')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('schedule_forms', function(Blueprint $table) {
			$table->foreign('package_id')->references('id')->on('packages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('section_forms', function(Blueprint $table) {
			$table->foreign('multi_package_section_id')->references('id')->on('multi_package_sections')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('section_forms', function(Blueprint $table) {
			$table->foreign('package_id')->references('id')->on('packages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('section_forms', function(Blueprint $table) {
			$table->foreign('schedule_form_id')->references('id')->on('schedule_forms')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('select_date', function(Blueprint $table) {
			$table->foreign('schedule_form_id')->references('id')->on('schedule_forms')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('select_time', function(Blueprint $table) {
			$table->foreign('select_time_id')->references('id')->on('select_date')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('ratings', function(Blueprint $table) {
			$table->foreign('package_id')->references('id')->on('packages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('ratings', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('multiple_packages', function(Blueprint $table) {
			$table->foreign('package_section_id')->references('id')->on('package_sections')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('multi_package_sections', function(Blueprint $table) {
			$table->foreign('multiple_package_id')->references('id')->on('multiple_packages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('mentors', function(Blueprint $table) {
			$table->dropForeign('mentors_tag_id_foreign');
		});
		Schema::table('mentors', function(Blueprint $table) {
			$table->dropForeign('mentors_user_id_foreign');
		});
		Schema::table('social_links', function(Blueprint $table) {
			$table->dropForeign('social_links_mentor_id_foreign');
		});
		Schema::table('packages', function(Blueprint $table) {
			$table->dropForeign('packages_mentor_id_foreign');
		});
		Schema::table('packages', function(Blueprint $table) {
			$table->dropForeign('packages_package_section_id_foreign');
		});
		Schema::table('schedule_forms', function(Blueprint $table) {
			$table->dropForeign('schedule_forms_package_id_foreign');
		});
		Schema::table('section_forms', function(Blueprint $table) {
			$table->dropForeign('section_forms_multi_package_section_id_foreign');
		});
		Schema::table('section_forms', function(Blueprint $table) {
			$table->dropForeign('section_forms_package_id_foreign');
		});
		Schema::table('section_forms', function(Blueprint $table) {
			$table->dropForeign('section_forms_schedule_form_id_foreign');
		});
		Schema::table('select_date', function(Blueprint $table) {
			$table->dropForeign('select_date_schedule_form_id_foreign');
		});
		Schema::table('select_time', function(Blueprint $table) {
			$table->dropForeign('select_time_select_time_id_foreign');
		});
		Schema::table('ratings', function(Blueprint $table) {
			$table->dropForeign('ratings_package_id_foreign');
		});
		Schema::table('ratings', function(Blueprint $table) {
			$table->dropForeign('ratings_user_id_foreign');
		});
		Schema::table('multiple_packages', function(Blueprint $table) {
			$table->dropForeign('multiple_packages_package_section_id_foreign');
		});
		Schema::table('multi_package_sections', function(Blueprint $table) {
			$table->dropForeign('multi_package_sections_multiple_package_id_foreign');
		});
	}
}