<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLicensesTable extends Migration {

	public function up()
	{
		Schema::create('licenses', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('resume_id')->unsigned()->index();
			$table->bigInteger('company_id')->unsigned()->index();
			$table->json('name');
			$table->string('credential_id', 50)->nullable();
			$table->string('credential_url', 191)->nullable();
			$table->timestamp('Issue_date');
			$table->timestamp('expiration_date')->nullable();
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('licenses');
	}
}