<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('notifications', function(Blueprint $table) {
			$table->string('id', 36)->unique();
			$table->string('type', 255);
			$table->integer('notifiable_id')->unsigned();
			$table->string('notifiable_type', 255);
			$table->text('data');
			$table->timestamp('read_at')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('notifications');
	}
}