<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('courses', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('courses_questions', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('courses_users_progresses', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('courses_users_results', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('courses_users_results', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('courses', function(Blueprint $table) {
			$table->dropForeign('courses_user_id_foreign');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->dropForeign('courses_category_id_foreign');
		});
		Schema::table('courses_questions', function(Blueprint $table) {
			$table->dropForeign('courses_questions_course_id_foreign');
		});
		Schema::table('courses_users_progresses', function(Blueprint $table) {
			$table->dropForeign('courses_users_progresses_course_id_foreign');
		});
		Schema::table('courses_users_results', function(Blueprint $table) {
			$table->dropForeign('courses_users_results_user_id_foreign');
		});
		Schema::table('courses_users_results', function(Blueprint $table) {
			$table->dropForeign('courses_users_results_course_id_foreign');
		});
	}
}