<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Mahasiswa extends Model 
{

    protected $table = 'mahasiswa_sarjana';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function rencanastudi()
    {
        return $this->hasMany('RencanaStudi', 'mahasiswa_id');
    }

    public function tahunakademik()
    {
        return $this->belongsTo('TahunAkademik', 'tahunmasuk');
    }

    public function dosen()
    {
        return $this->belongsTo('Dosen');
    }

    public function agama()
    {
        return $this->belongsTo('Agama', 'agama_id');
    }

    public function orangtua()
    {
        return $this->hasMany('Mahasiswa');
    }

}