<?php

namespace App\Models;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('name', 'email', 'password', 'phone', 'date_of_birth', 'blood_type_id', 'city_id');

	public function getBloodType()
	{
		return $this->belongsToMany('App\Models\BloodType');
	}

	public function getCity()
	{
		return $this->belongsTo('App\Models\City');
	}

	public function getNotification()
	{
		return $this->belongsToMany('App\Models\Notification');
	}

	public function getPosts()
	{
		return $this->belongsToMany('App\Models\Post');
	}

	public function GetDonations()
	{
		return $this->hasMany('App\Models\DR');
	}

}