<?php

namespace App\Models;

class DR extends Eloquent {

	protected $table = 'donation_requests';
	public $timestamps = true;
	protected $guarded = array('client_id', 'city_id');
	protected $fillable = array('patient_name', 'patient_age', 'blood_type_id', 'hospital_address', 'bags_num', 'patient_phone', 'hospital_name', 'details', 'latitude', 'longitude');

	public function getCity()
	{
		return $this->hasMany('City');
	}

	public function getBloodType()
	{
		return $this->hasOne('App\Models\BloodType');
	}

	public function getClient()
	{
		return $this->hasOne('App\Models\Client');
	}

}