<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRatesTable extends Migration {

	public function up()
	{
		Schema::create('rates', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('comment');
			$table->decimal('rate')->default('0');
			$table->timestamps();
			$table->integer('sub_service_id')->unsigned()->nullable();
			$table->string('status');
		});
	}

	public function down()
	{
		Schema::drop('rates');
	}
}