<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PaymentHistory extends Eloquent {

	protected $table = 'payment_history';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('company_id', 'user_id', 'status', 'total', 'payment_method_id', 'order_id');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function company()
	{
		return $this->belongsTo('Company', 'company_id');
	}

	public function payment_method()
	{
		return $this->belongsTo('PaymentMethod', 'payment_method_id');
	}

	public function order()
	{
		return $this->belongsTo('Order', 'order_id');
	}

}