<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Order extends Eloquent {

	protected $table = 'order';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'company_id', 'package_id', 'start_at', 'expire_at', 'grace_at', 'grace_number', 'status', 'payment_method_id', 'months_number', 'active_members', 'max_members', 'cancel_date', 'is_trail', 'trail_end_at', 'package_title_en', 'package_title_ar', 'package_description_en', 'package_description_ar', 'package_price', 'subscription_price', 'support_price', 'total');

	public function payment_method()
	{
		return $this->belongsTo('PaymentMethod', 'payment_method_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function company()
	{
		return $this->belongsTo('Company', 'company_id');
	}

	public function package()
	{
		return $this->belongsTo('Package', 'package_id');
	}

}