<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PackageFeature extends Model 
{

    protected $table = 'package_feature';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('package_id', 'feature_id');

    public function package()
    {
        return $this->belongsTo('Package', 'package_id');
    }

    public function feature()
    {
        return $this->belongsTo('Feature', 'feature_id');
    }

}