<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFactoriesTable extends Migration {

	public function up()
	{
		Schema::create('factories', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->boolean('isIsland')->nullable()->default(false);
			$table->string('project_name', 255)->nullable();
			$table->integer('continent_id')->unsigned();
			$table->integer('country_id')->unsigned();
			$table->integer('state_id')->unsigned();
			$table->integer('city_id')->unsigned();
			$table->float('rated_power')->nullable()->default('0');
			$table->float('energy_capacity')->nullable()->default('0');
			$table->float('discharge_duration')->nullable();
			$table->integer('status_id')->unsigned();
			$table->integer('revenue_id')->unsigned();
			$table->integer('connection_point_id')->unsigned();
			$table->date('annoncement_date')->nullable();
			$table->string('paired_grid_resource')->nullable();
			$table->date('commissioning_date')->nullable();
			$table->integer('research_institution_id')->unsigned();
			$table->integer('off_taker_id')->unsigned();
			$table->integer('funding_source_id')->unsigned();
			$table->longText('decsription')->nullable()->default('65000');
			$table->boolean('verified')->nullable();
			$table->longText('verification_description')->nullable();
			$table->date('expected_commissioning_date')->nullable();
			$table->integer('company_id')->unsigned();
			$table->string('enery_storage_technology', 255)->nullable();
			$table->string('power_electronics_manufacturer', 255)->nullable();
			$table->string('system_integrator', 255)->nullable();
			$table->string('om_contractor', 255)->nullable();
			$table->string('epc', 255)->nullable();
			$table->string('developer', 255)->nullable();
			$table->string('owner', 255)->nullable();
			$table->string('hyperlink_1', 255)->nullable();
			$table->string('hyperlink_2')->nullable();
			$table->string('hyperlink_3');
		});
	}

	public function down()
	{
		Schema::drop('factories');
	}
}