<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServicesDataTable extends Migration {

	public function up()
	{
		Schema::create('services_data', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('service_id')->unsigned()->index();
			$table->string('question', 255);
			$table->string('label', 255);
			$table->enum('type', array(''select'', ''radio'', ''text''));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('services_data');
	}
}