<?php

namespace Wolfie\Models;

class Pro extends Eloquent {

	protected $table = 'pros';
	public $timestamps = true;
	protected $fillable = array('user_id', 'credits', 'location', 'cords');
	protected $visible = array('location', 'cords');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function featured()
	{
		return $this->hasMany('Featured', 'pro_id')->withPivot('valid_until');
	}

	public function ready()
	{
		return $this->hasMany('Ready', 'pro_id')->withPivot('valid_until');
	}

	public function services()
	{
		return $this->belongsToMany('Service', 'pro_service', 'pro_id', 'service_id');
	}

	public function threads()
	{
		return $this->hasMany('Thread', 'pro_id')->withPivot();
	}

	public function authorable()
	{
		return $this->morphMany('Reviews', 'authorable');
	}

	public function reachabilities()
	{
		return $this->belongsToMany('Reachability', 'pro_reachability', 'pro_id', 'reachability_id');
	}

	public function messages()
	{
		return $this->morphMany('Message', 'to');
	}

}