<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdsTable extends Migration {

	public function up()
	{
		Schema::create('ads', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('client_id')->unsigned()->index();
			$table->integer('service_id')->unsigned()->index();
			$table->string('location', 255)->nullable();
			$table->string('cords', 255)->nullable();
			$table->date('date')->nullable();
			$table->enum('date_type', array(''exact'', ''flexible''))->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('ads');
	}
}