<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServicesTable extends Migration {

	public function up()
	{
		Schema::create('services', function(Blueprint $table) {
			$table->increments('id');
			$table->string('label', 255);
			$table->string('slug', 255);
			$table->integer('credits')->default('0');
			$table->integer('parent_id')->unsigned()->nullable()->index();
			$table->integer('lft');
			$table->integer('rgt')->nullable()->default('0');
			$table->timestamps();
			$table->string('image')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('services');
	}
}