<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('day_books', function(Blueprint $table) {
			$table->foreign('ledger_id')->references('id')->on('ledgers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('day_books', function(Blueprint $table) {
			$table->foreign('day_bk_status')->references('id')->on('day_book_status')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('transaction_password', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('day_books', function(Blueprint $table) {
			$table->dropForeign('day_books_ledger_id_foreign');
		});
		Schema::table('day_books', function(Blueprint $table) {
			$table->dropForeign('day_books_day_bk_status_foreign');
		});
		Schema::table('transaction_password', function(Blueprint $table) {
			$table->dropForeign('transaction_password_user_id_foreign');
		});
	}
}