<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInteractionTable extends Migration {

	public function up()
	{
		Schema::create('interaction', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('client_id');
			$table->bigInteger('user_id');
			$table->bigInteger('ticket_id')->unsigned();
			$table->enum('type', array('internal', 'external'));
			$table->string('description');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('interaction');
	}
}