<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAccountServicesTable extends Migration {

	public function up()
	{
		Schema::create('account_services', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('account_id')->unique()->unsigned();
			$table->string('name', 9);
			$table->text('description')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('account_services');
	}
}