<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookingAddressTable extends Migration {

	public function up()
	{
		Schema::create('booking_address', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('booking_id')->unsigned();
			$table->string('street');
			$table->string('apt_number');
			$table->string('city');
			$table->string('state')->nullable();
			$table->string('zip', 5)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('booking_address');
	}
}