<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid')->index();
			$table->string('email')->unique();
			$table->string('password');
			$table->softDeletes();
			$table->timestamps();
			$table->datetime('verified_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}