<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Activity extends Eloquent {

	protected $table = 'activities';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function eventable()
	{
		return $this->morphTo();
	}

	public function user()
	{
		return $this->belongsTo('User');
	}

}