<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('client_id')->unsigned()->nullable();
			$table->bigInteger('delivery_id')->unsigned()->nullable();
			$table->bigInteger('address_id')->unsigned()->nullable();
			$table->bigInteger('order_status_id')->unsigned()->nullable();
			$table->string('description')->nullable();
			$table->string('price')->nullable();
			$table->string('delivery_price')->nullable();
			$table->string('notes')->nullable();
			$table->timestamps();
			$table->bigInteger('shop_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}