<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('client_phones', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('states', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('delivery_id')->references('id')->on('deliveries')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('address_id')->references('id')->on('addresses')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('order_status_id')->references('id')->on('order_statuses')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('shop_id')->references('id')->on('shops')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('delivery_prices', function(Blueprint $table) {
			$table->foreign('backup_id')->references('id')->on('states')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('delivery_prices', function(Blueprint $table) {
			$table->foreign('address_id')->references('id')->on('states')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->foreign('state_id')->references('id')->on('states')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('deliveries', function(Blueprint $table) {
			$table->foreign('vehicle_id')->references('id')->on('vehicles')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('shops', function(Blueprint $table) {
			$table->foreign('state_id')->references('id')->on('states')
						->onDelete('set null')
						->onUpdate('set null');
		});
	}

	public function down()
	{
		Schema::table('client_phones', function(Blueprint $table) {
			$table->dropForeign('client_phones_client_id_foreign');
		});
		Schema::table('states', function(Blueprint $table) {
			$table->dropForeign('states_city_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_client_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_delivery_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_address_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_order_status_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_shop_id_foreign');
		});
		Schema::table('delivery_prices', function(Blueprint $table) {
			$table->dropForeign('delivery_prices_backup_id_foreign');
		});
		Schema::table('delivery_prices', function(Blueprint $table) {
			$table->dropForeign('delivery_prices_address_id_foreign');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->dropForeign('addresses_client_id_foreign');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->dropForeign('addresses_state_id_foreign');
		});
		Schema::table('deliveries', function(Blueprint $table) {
			$table->dropForeign('deliveries_vehicle_id_foreign');
		});
		Schema::table('shops', function(Blueprint $table) {
			$table->dropForeign('shops_state_id_foreign');
		});
	}
}