<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateArticlesTable extends Migration {

	public function up()
	{
		Schema::create('articles', function(Blueprint $table) {
			$table->string('article_id')->unique()->primary();
			$table->string('titre');
			$table->string('resume');
			$table->string('image');
			$table->longText('contenu');
			$table->string('tag_id');
			$table->string('categorie_id');
			$table->string('thematique_id');
			$table->string('author_id');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('articles');
	}
}