<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('information');

    public function phones()
    {
        return $this->hasMany('Phone');
    }

    public function adresses()
    {
        return $this->hasMany('Adress');
    }

    public function role()
    {
        return $this->hasOne('Role');
    }

    public function sonuclar()
    {
        return $this->hasMany('SinavSonucGenel');
    }

}