<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Companies extends Model 
{

    protected $table = 'companies';
    public $timestamps = true;

    public function contacts()
    {
        return $this->hasMany('Contacts', 'contacts');
    }

    public function postal_country()
    {
        return $this->hasOne('Companies');
    }

    public function shipping_country()
    {
        return $this->hasOne('Companies');
    }

    public function primary_contact()
    {
        return $this->hasOne('Contacts', 'id');
    }

}