<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('name1');
			$table->string('name2');
			$table->string('phone');
			$table->string('mobile');
			$table->string('fax');
			$table->string('website');
			$table->string('postal_street');
			$table->string('postal_plc');
			$table->string('postal_city');
			$table->integer('postal_country')->unsigned();
			$table->string('delivery_street');
			$table->string('delivery_plc');
			$table->string('delivery_city');
			$table->integer('delivery_country')->unsigned();
			$table->integer('debitor');
			$table->integer('kreditor');
			$table->string('IBAN');
			$table->string('BIC');
			$table->string('vatnumber');
			$table->integer('FK_parantcompany');
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}