<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDoclinesTable extends Migration {

	public function up()
	{
		Schema::create('doclines', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->text('text');
			$table->integer('amount');
			$table->integer('amount_delivered');
			$table->integer('amount_billed');
			$table->decimal('singleprice');
			$table->decimal('groupprice');
			$table->integer('order');
			$table->boolean('isgroup')->default(false);
			$table->boolean('isoptional')->default(false);
			$table->integer('FK_product_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('doclines');
	}
}