<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDocsTable extends Migration {

	public function up()
	{
		Schema::create('docs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('doctype');
			$table->integer('docnumber');
			$table->string('docname');
			$table->boolean('isaarchived')->default(false);
			$table->string('title');
			$table->text('headertext');
			$table->text('footertext');
			$table->decimal('totalnet');
			$table->decimal('discountpercent');
			$table->decimal('totaltax');
			$table->decimal('totalbrt');
			$table->integer('parentdoc')->unsigned();
			$table->integer('project_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('docs');
	}
}