<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('categoryid')->unsigned();
			$table->string('name_de');
			$table->string('name_en');
			$table->string('name_ru');
			$table->text('details_de');
			$table->text('details_en');
			$table->text('details_ru');
			$table->string('manufacturer');
			$table->string('year');
			$table->string('model');
			$table->string('serial_number');
			$table->decimal('weight');
			$table->text('internal_notice');
			$table->decimal('purchase_price');
			$table->decimal('sales_price');
			$table->boolean('show_frontend');
			$table->enum('machine_status', array('quoted', 'bought', 'sold', 'service', 'unavailable'));
			$table->integer('company_incoming')->unsigned();
			$table->integer('contact_incoming')->unsigned();
			$table->integer('company_outgoing')->unsigned();
			$table->integer('contact_outgoing')->unsigned();
			$table->enum('quoting', array('auto', 'manual', 'showprice'));
			$table->boolean('newsletter')->default(true);
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}