<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('image', 255)->nullable();
			$table->string('name', 255)->nullable();
			$table->string('country_code', 255)->nullable();
			$table->string('phone', 255)->nullable();
			$table->string('email', 255)->nullable();
			$table->string('password', 255)->nullable();
			$table->integer('city_id')->unsigned();
			$table->string('code', 255);
			$table->text('lat')->nullable();
			$table->text('lng')->nullable();
			$table->text('map_desc')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}