<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInstructionsTable extends Migration {

	public function up()
	{
		Schema::create('instructions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name')->unique();
			$table->string('regex');
			$table->integer('project_id')->unsigned()->nullable();
			$table->integer('group_id')->unsigned()->nullable();
			$table->integer('subscription_id')->unsigned()->nullable();
			$table->text('body')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('instructions');
	}
}