<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Post extends Eloquent {

	protected $table = 'posts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('id_group', 'title', 'banner', 'content', 'status', 'id_user');
	protected $visible = array('id_group', 'title', 'banner', 'content', 'status', 'id_user');

	public function group()
	{
		return $this->belongsTo('App\Models\Groupe', 'id_group');
	}

	public function comments()
	{
		return $this->hasMany('App\Models\Comment', 'id_post');
	}

}