<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class UserGroup extends Eloquent {

	protected $table = 'user_group';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $visible = array('id_user', 'id_group');

	public function user()
	{
		return $this->belongsTo('App\Models\User', 'id_user');
	}

	public function group()
	{
		return $this->belongsTo('App\Models\Group', 'id_group');
	}

}