<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFacilitiesTable extends Migration {

	public function up()
	{
		Schema::create('facilities', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('owner_id')->unsigned()->index();
			$table->integer('manager_owner_id')->unsigned()->index();
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 256)->index();
			$table->string('timezone', 80)->index();
			$table->enum('state', array('VIC', 'NSW', 'ACT', 'WA', 'QLD', 'NT', 'TAS.SA', 'OTHER'))->index();
			$table->string('country', 2)->index();
			$table->tinyInteger('service_level')->index();
			$table->tinyInteger('category')->index();
			$table->enum('facility_type', array('SURGICAL', 'NON-SURGICAL'))->index();
			$table->string('legacy_id', 32)->nullable()->index();
			$table->string('import_id', 64)->nullable();
			$table->string('source', 32)->nullable();
			$table->string('import_version', 15);
			$table->string('permissions')->nullable()->default('json');
			$table->string('facility_role', 32);
		});
	}

	public function down()
	{
		Schema::drop('facilities');
	}
}