<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserFacilitiesTable extends Migration {

	public function up()
	{
		Schema::create('user_facilities', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('facility_id')->unsigned()->index();
			$table->integer('user_id')->unsigned()->index();
			$table->timestamps();
			$table->string('permissions')->nullable()->default('json');
			$table->enum('user_role', array('SHARED_LOGIN', 'HCW', 'CORPORATE', 'CONTACT', 'CONSULTANT'))->index();
		});
	}

	public function down()
	{
		Schema::drop('user_facilities');
	}
}