<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOwnerDefinedCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('owner_defined_categories', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('owner_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 128)->index();
			$table->string('description', 256);
		});
	}

	public function down()
	{
		Schema::drop('owner_defined_categories');
	}
}