<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Company extends Model 
{

    protected $table = 'company';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function products()
    {
        return $this->belongsToMany('Product');
    }

    public function region()
    {
        return $this->belongsTo('Region');
    }

}