<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class FundHistory extends Eloquent {

	protected $table = 'fund_history';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('fund_id', 'user_id', 'receipt_id', 'client_id');

	public function fund()
	{
		return $this->belongsTo('Fund', 'fund_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function reciept()
	{
		return $this->belongsTo('Receipt', 'receipt_id');
	}

	public function shipping()
	{
		return $this->belongsTo('Shipping', 'shipping_id');
	}

	public function client()
	{
		return $this->belongsTo('Client', 'client_id');
	}

}