<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ShippingContent extends Eloquent {

	protected $table = 'shipping_content';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'client_id', 'source', 'type', 'goods_type', 'height', 'width', 'length', 'number', 'cofactor_id', 'amount', 'area', 'note', 'shipping_id', 'chassis_number', 'car_type', 'price', 'arrival_date', 'exit_number', 'still_in');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function shipping()
	{
		return $this->belongsTo('Shipping', 'shipping_id');
	}

	public function cofactor()
	{
		return $this->belongsTo('Cofactor', 'cofactor_id');
	}

	public function client()
	{
		return $this->belongsTo('Client', 'client_id');
	}

}