<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Store extends Eloquent {

	protected $table = 'store';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('number', 'phone', 'country_id', 'user_id', 'address', 'type');

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function entries()
	{
		return $this->hasMany('StoreEntry', 'store_id');
	}

	public function exits()
	{
		return $this->hasMany('StoreExit', 'store_id');
	}

}