<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->nullable();
			$table->string('description')->nullable();
			$table->integer('warranty_duration')->nullable();
			$table->string('warranty_plan')->nullable();
			$table->string('sku')->nullable();
			$table->string('upc_code')->nullable();
			$table->tinyInteger('has_barcode')->nullable();
			$table->string('image')->nullable();
			$table->tinyInteger('is_displayed')->nullable();
			$table->integer('category_id')->unsigned();
			$table->integer('store_id')->unsigned();
			$table->integer('manufacturer_id')->unsigned();
			$table->integer('retail_price')->nullable();
			$table->integer('cost_price')->nullable();
			$table->integer('sale_price')->nullable();
			$table->string('TAX_CLASS')->nullable();
			$table->tinyInteger('tax_inclusive')->nullable();
			$table->tinyInteger('is_inventory_managed')->nullable();
			$table->integer('in_stock')->nullable();
			$table->integer('stock_warning_limit')->nullable();
			$table->integer('reorder_level')->nullable();
			$table->string('physical_location')->nullable();
			$table->integer('supplier_id')->unsigned();
			$table->string('MANAGE_SERIALIZED_INVENTORY')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}