<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserPollAnswersTable extends Migration {

	public function up()
	{
		Schema::create('user_poll_answers', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id');
			$table->integer('poll_answers_id')->unsigned();
			$table->boolean('is_poll_owner')->default(false);
			$table->text('comment')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('user_poll_answers');
	}
}