<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateComputerSkillsTable extends Migration {

	public function up()
	{
		Schema::create('computer_skills', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('computer_skill')->nullable();
			$table->enum('computer_skills_level', array('Exellent', 'VeryGood', 'Good', 'Intermediate'))->nullable();
			$table->bigInteger('cv_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('computer_skills');
	}
}