<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('provinces', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('province_id')->references('id')->on('provinces')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('yellow_page_departments', function(Blueprint $table) {
			$table->foreign('yellow_page_id')->references('id')->on('yellow_pages')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('affiliates', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('affiliates', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('affiliates_transfers_to_admin', function(Blueprint $table) {
			$table->foreign('affiliate_id')->references('id')->on('affiliates')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('affiliate_clients', function(Blueprint $table) {
			$table->foreign('affiliate_transfer_to_admin_id')->references('id')->on('affiliates_transfers_to_admin')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('affiliate_clients', function(Blueprint $table) {
			$table->foreign('yellow_page_department_id')->references('id')->on('yellow_page_departments')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('affiliate_clients', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('affiliate_clients', function(Blueprint $table) {
			$table->foreign('affiliate_id')->references('id')->on('affiliates')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('affiliate_balance_not_receiveds', function(Blueprint $table) {
			$table->foreign('affiliate_id')->references('id')->on('affiliates')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('affiliate_balance_receiveds', function(Blueprint $table) {
			$table->foreign('affiliate_id')->references('id')->on('affiliates')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('classified_departments', function(Blueprint $table) {
			$table->foreign('classified_id')->references('id')->on('classifieds')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('classified_department_fields', function(Blueprint $table) {
			$table->foreign('classified_department_id')->references('id')->on('classified_departments')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->foreign('classified_department_id')->references('id')->on('classified_departments')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currencies')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('yellow_services_affiliate_clients', function(Blueprint $table) {
			$table->foreign('yellow_service_id')->references('id')->on('yellow_services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('yellow_services_affiliate_clients', function(Blueprint $table) {
			$table->foreign('affiliate_client_id')->references('id')->on('affiliate_clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('elements', function(Blueprint $table) {
			$table->foreign('affiliate_id')->references('id')->on('affiliates')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('elements', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('elements', function(Blueprint $table) {
			$table->foreign('yellow_page_department_id')->references('id')->on('classified_departments')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('elements', function(Blueprint $table) {
			$table->foreign('affiliate_client_id')->references('id')->on('affiliate_clients')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('blogs', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('advertisements', function(Blueprint $table) {
			$table->foreign('site_language_id')->references('id')->on('site_languages')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('advertisements', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('admin_transfers_to_affiliates', function(Blueprint $table) {
			$table->foreign('affiliate_id')->references('id')->on('affiliates')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('yellow_page_advertisements', function(Blueprint $table) {
			$table->foreign('advertisement_id')->references('id')->on('advertisements')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('yellow_page_advertisements', function(Blueprint $table) {
			$table->foreign('yellow_page_id')->references('id')->on('yellow_pages')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('yellow_page_department_advertisements', function(Blueprint $table) {
			$table->foreign('advertisement_id')->references('id')->on('advertisements')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('yellow_page_department_advertisements', function(Blueprint $table) {
			$table->foreign('yellow_page_department_id')->references('id')->on('yellow_page_departments')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('classified_advertisements', function(Blueprint $table) {
			$table->foreign('advertisement_id')->references('id')->on('advertisements')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('classified_advertisements', function(Blueprint $table) {
			$table->foreign('classified_id')->references('id')->on('classifieds')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('classified_department_advertisements', function(Blueprint $table) {
			$table->foreign('advertisement_id')->references('id')->on('advertisements')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('classified_department_advertisements', function(Blueprint $table) {
			$table->foreign('classified_department_id')->references('id')->on('classified_departments')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('stores', function(Blueprint $table) {
			$table->foreign('store_category_id')->references('id')->on('store_categories')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('stores', function(Blueprint $table) {
			$table->foreign('province_id')->references('id')->on('provinces')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currencies')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('stores')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('cvs', function(Blueprint $table) {
			$table->foreign('classified_department_id')->references('id')->on('classified_departments')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('cvs', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('personal_informations', function(Blueprint $table) {
			$table->foreign('cv_id')->references('id')->on('cvs')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('computer_skills', function(Blueprint $table) {
			$table->foreign('cv_id')->references('id')->on('cvs')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('interests', function(Blueprint $table) {
			$table->foreign('cv_id')->references('id')->on('cvs')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('skills', function(Blueprint $table) {
			$table->foreign('cv_id')->references('id')->on('cvs')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('qualifications', function(Blueprint $table) {
			$table->foreign('cv_id')->references('id')->on('cvs')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('soft_skills', function(Blueprint $table) {
			$table->foreign('cv_id')->references('id')->on('cvs')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('languages', function(Blueprint $table) {
			$table->foreign('cv_id')->references('id')->on('cvs')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('provinces', function(Blueprint $table) {
			$table->dropForeign('provinces_country_id_foreign');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_province_id_foreign');
		});
		Schema::table('yellow_page_departments', function(Blueprint $table) {
			$table->dropForeign('yellow_page_departments_yellow_page_id_foreign');
		});
		Schema::table('affiliates', function(Blueprint $table) {
			$table->dropForeign('affiliates_city_id_foreign');
		});
		Schema::table('affiliates', function(Blueprint $table) {
			$table->dropForeign('affiliates_user_id_foreign');
		});
		Schema::table('affiliates_transfers_to_admin', function(Blueprint $table) {
			$table->dropForeign('affiliates_transfers_to_admin_affiliate_id_foreign');
		});
		Schema::table('affiliate_clients', function(Blueprint $table) {
			$table->dropForeign('affiliate_clients_affiliate_transfer_to_admin_id_foreign');
		});
		Schema::table('affiliate_clients', function(Blueprint $table) {
			$table->dropForeign('affiliate_clients_yellow_page_department_id_foreign');
		});
		Schema::table('affiliate_clients', function(Blueprint $table) {
			$table->dropForeign('affiliate_clients_city_id_foreign');
		});
		Schema::table('affiliate_clients', function(Blueprint $table) {
			$table->dropForeign('affiliate_clients_affiliate_id_foreign');
		});
		Schema::table('affiliate_balance_not_receiveds', function(Blueprint $table) {
			$table->dropForeign('affiliate_balance_not_receiveds_affiliate_id_foreign');
		});
		Schema::table('affiliate_balance_receiveds', function(Blueprint $table) {
			$table->dropForeign('affiliate_balance_receiveds_affiliate_id_foreign');
		});
		Schema::table('classified_departments', function(Blueprint $table) {
			$table->dropForeign('classified_departments_classified_id_foreign');
		});
		Schema::table('classified_department_fields', function(Blueprint $table) {
			$table->dropForeign('classified_department_fields_classified_department_id_foreign');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->dropForeign('posts_city_id_foreign');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->dropForeign('posts_classified_department_id_foreign');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->dropForeign('posts_currency_id_foreign');
		});
		Schema::table('yellow_services_affiliate_clients', function(Blueprint $table) {
			$table->dropForeign('yellow_services_affiliate_clients_yellow_service_id_foreign');
		});
		Schema::table('yellow_services_affiliate_clients', function(Blueprint $table) {
			$table->dropForeign('yellow_services_affiliate_clients_affiliate_client_id_foreign');
		});
		Schema::table('elements', function(Blueprint $table) {
			$table->dropForeign('elements_affiliate_id_foreign');
		});
		Schema::table('elements', function(Blueprint $table) {
			$table->dropForeign('elements_city_id_foreign');
		});
		Schema::table('elements', function(Blueprint $table) {
			$table->dropForeign('elements_yellow_page_department_id_foreign');
		});
		Schema::table('elements', function(Blueprint $table) {
			$table->dropForeign('elements_affiliate_client_id_foreign');
		});
		Schema::table('blogs', function(Blueprint $table) {
			$table->dropForeign('blogs_country_id_foreign');
		});
		Schema::table('advertisements', function(Blueprint $table) {
			$table->dropForeign('advertisements_site_language_id_foreign');
		});
		Schema::table('advertisements', function(Blueprint $table) {
			$table->dropForeign('advertisements_country_id_foreign');
		});
		Schema::table('admin_transfers_to_affiliates', function(Blueprint $table) {
			$table->dropForeign('admin_transfers_to_affiliates_affiliate_id_foreign');
		});
		Schema::table('yellow_page_advertisements', function(Blueprint $table) {
			$table->dropForeign('yellow_page_advertisements_advertisement_id_foreign');
		});
		Schema::table('yellow_page_advertisements', function(Blueprint $table) {
			$table->dropForeign('yellow_page_advertisements_yellow_page_id_foreign');
		});
		Schema::table('yellow_page_department_advertisements', function(Blueprint $table) {
			$table->dropForeign('yellow_page_department_advertisements_advertisement_id_foreign');
		});
		Schema::table('yellow_page_department_advertisements', function(Blueprint $table) {
			$table->dropForeign('yellow_page_department_advertisements_yellow_page_department_id_foreign');
		});
		Schema::table('classified_advertisements', function(Blueprint $table) {
			$table->dropForeign('classified_advertisements_advertisement_id_foreign');
		});
		Schema::table('classified_advertisements', function(Blueprint $table) {
			$table->dropForeign('classified_advertisements_classified_id_foreign');
		});
		Schema::table('classified_department_advertisements', function(Blueprint $table) {
			$table->dropForeign('classified_department_advertisements_advertisement_id_foreign');
		});
		Schema::table('classified_department_advertisements', function(Blueprint $table) {
			$table->dropForeign('classified_department_advertisements_classified_department_id_foreign');
		});
		Schema::table('stores', function(Blueprint $table) {
			$table->dropForeign('stores_store_category_id_foreign');
		});
		Schema::table('stores', function(Blueprint $table) {
			$table->dropForeign('stores_province_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_currency_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_store_id_foreign');
		});
		Schema::table('cvs', function(Blueprint $table) {
			$table->dropForeign('cvs_classified_department_id_foreign');
		});
		Schema::table('cvs', function(Blueprint $table) {
			$table->dropForeign('cvs_city_id_foreign');
		});
		Schema::table('personal_informations', function(Blueprint $table) {
			$table->dropForeign('personal_informations_cv_id_foreign');
		});
		Schema::table('computer_skills', function(Blueprint $table) {
			$table->dropForeign('computer_skills_cv_id_foreign');
		});
		Schema::table('interests', function(Blueprint $table) {
			$table->dropForeign('interests_cv_id_foreign');
		});
		Schema::table('skills', function(Blueprint $table) {
			$table->dropForeign('skills_cv_id_foreign');
		});
		Schema::table('qualifications', function(Blueprint $table) {
			$table->dropForeign('qualifications_cv_id_foreign');
		});
		Schema::table('soft_skills', function(Blueprint $table) {
			$table->dropForeign('soft_skills_cv_id_foreign');
		});
		Schema::table('languages', function(Blueprint $table) {
			$table->dropForeign('languages_cv_id_foreign');
		});
	}
}