<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class AdminTransferToAffiliate extends Model 
{

    protected $table = 'admin_transfers_to_affiliates';
    public $timestamps = true;
    protected $fillable = array('transfer_number', 'transfer_date', 'amount', 'received_by_affiliate', 'affiliate_id');

    public function liaisonOfficeClient()
    {
        return $this->hasMany('AffiliateClient');
    }

    public function affiliate()
    {
        return $this->belongsTo('User', 'affiliate_id', 'id');
    }

    public function getAffiliate()
    {
        return $this->belongsTo('Affiliate', 'affiliate_id', 'id');
    }

}