<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccidentEquipment extends Model 
{

    protected $table = 'accident_equipment';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('equipment_id', 'incident_id');

    public function equipment()
    {
        return $this->belongsTo('Equipment', 'equipment_id');
    }

    public function incident()
    {
        return $this->belongsTo('Incident', 'incident_id');
    }

}