<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Cause extends Model 
{

    protected $table = 'cause';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('description', 'type', 'incident_id');

    public function incident()
    {
        return $this->belongsTo('Incident', 'incident_id');
    }

}